<?php
/**
 * Created by PhpStorm.
 * User: sunusi
 * Date: 2019-02-11
 * Time: 21:02
 */



//generate config functions based on the configuration name from the database
function getConfig($configName)
{
    $query = new db();
    $config = $query->getOne("
      SELECT * 
      FROM udut_configurations 
      WHERE configName = '" . $configName . "'
    ");
    $configValue = $config["configValue"];
    return $configValue;
}
//generate the total monthly revenue to be used in the ppp sharing formula
function getTotalMonthlyRevenue($month)
{
    $query = new db();
    //fetch revenue according to month
    $sql = $query->getAll("
        SELECT udut_payments.*,
               udut_scan_types.*
        FROM udut_payments
        JOIN udut_scan_types
        ON udut_payments.typeId = udut_scan_types.typeId
        WHERE udut_payments.paymentDateAdded LIKE '%" . $month . "%'
    ");
    $totalAmount = 0;
    foreach ($sql as $revenue) {
        $totalAmount = $totalAmount + $revenue['typeAmount'];
    }
    return $totalAmount;
}
//generate total monthly revenue after removing the fixed running cost
function getTotalAfterRunningCost($month){
    $runningCost = getConfig("runningCost");
    $totalRevenue = getTotalMonthlyRevenue($month);
    $afterRunningCost = $totalRevenue - $runningCost;
    return $afterRunningCost;
}
//generate uduth percentage from function getTotalAfterRunningCost()
function getuduthPercentage($month){
    $uduthPercentage = getConfig("hosAccPer");
    $totalRevenue = getTotalAfterRunningCost($month);
    $uduthRevenue = ($uduthPercentage * $totalRevenue) / 100;
    return $uduthRevenue;
}
//generate management percentage from function getTotalAfterRunningCost()
function getManagementPercentage($month){
    $managementPercentage = getConfig("manAccPer");
    $totalRevenue = getTotalAfterRunningCost($month);
    $managementRevenue = ($managementPercentage * $totalRevenue) / 100;
    return $managementRevenue;
}
//generate total revenue after deducting uduth and management percentage
function getTotalAfterHnMPercentage($month){
    $uduthPercentage = getuduthPercentage($month);
    $managementPercentage = getManagementPercentage($month);
    $deducted = $uduthPercentage + $managementPercentage;
    $totalRevenue = getTotalAfterRunningCost($month) - $deducted;
    return $totalRevenue;
}
//generate foresight percentage after uduth and management percentage
function getForesightPercentage($month){
    $foresightPercentage = getConfig("foresightPer");
    $afterHnM = getTotalAfterHnMPercentage($month);
    $totalRevenue = ($foresightPercentage * $afterHnM) / 100;
    return $totalRevenue;
}
//generate khalifa percentage as remaining percent of the foresight
function getkhalifaPercentage($month){
    $khalifaPercentage = getConfig("khalifaPer");
    $afterHnM = getTotalAfterHnMPercentage($month);
    $totalRevenue = ($khalifaPercentage * $afterHnM) / 100;
    return $totalRevenue;
}
//splitting uduth 30% percentage into the following functions
//generate uduth account percentage
function getuduthAccountPercentage($month){
    $uduthAccount = getConfig("hosHosAccPer");
    $uduthPercentage = getTotalAfterRunningCost($month);
    $totalRevenue = ($uduthAccount * $uduthPercentage) / 100;
    return $totalRevenue;
}
//generate administration fee
function getAdministrationFeePercentage($month){
    $administrationFee = getConfig("hosAdmFee");
    $uduthPercentage = getTotalAfterRunningCost($month);
    $totalRevenue = ($administrationFee * $uduthPercentage) / 100;
    return $totalRevenue;
}
//generate CMD percentage
function getCMDPercentage($month){
    $uduthCMD = getConfig("hosCMD");
    $uduthPercentage = getTotalAfterRunningCost($month);
    $totalRevenue = ($uduthCMD * $uduthPercentage) / 100;
    return $totalRevenue;
}
//generate Dr. Admin percentage
function getDrAdminPercentage($month){
    $uduthDrAdmin = getConfig("hosDrAdm");
    $uduthPercentage = getTotalAfterRunningCost($month);
    $totalRevenue = ($uduthDrAdmin * $uduthPercentage) / 100;
    return $totalRevenue;
}
//generate radiology department percentage
function getRadiologyDepartmentPercentage($month){
    $uduthRadiologyDepartment = getConfig("hosRadDep");
    $uduthPercentage = getTotalAfterRunningCost($month);
    $totalRevenue = ($uduthRadiologyDepartment * $uduthPercentage) / 100;
    return $totalRevenue;
}

